*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file for Nids Wave 2

* THIS IS 3rd WEALTH DO FILE - PREPARING VARIABLES FOR IMPUTATION: 3 OF 6
* THIS DO FILE PREPARES THE RELEVANT WEALTH VARIABLES FOR IMPUTATION

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master wealth do file (1 of 6)"

version 12.0

*=====================================================================================================================================

* OPENING THE DATASET CREATED IN THE DO FILE "Wealth - Merging datasets to create wealth variables (2 of 6)"

use "$DataOUT\data.dta", clear

set more off
*-------------------------------------------------------------------------------------------------------------------------------------

*****************
*Response status*
*****************

*Variable that indicates whether the individual has a response at all (including proxies)
gen response=outcome==1
label variable response "Did individual respond or not (incl. proxies)"
label values response dummy

*Variable that indicates the outcome of attempted sampling of this unit
gen responseoutcome=response
replace responseoutcome=2 if proxy==1
label define responseoutcome 0 "Non-response" 1 "Adult" 2 "Proxy"
label values responseoutcome responseoutcome 

*Month of interview
gen temp=.
replace temp=intrv_m if intrv_y==2010
replace temp=intrv_m+12 if intrv_y==2011
replace temp=25 if temp==.
rename temp intmonth

*Year of interview
gen int2010=intrv_y==2010
gen int2011=intrv_y==2011
replace int2010=1 if intrv_y==2008
replace int2011=1 if intrv_y==-3

**************
*Demographics*
**************

********
*Gender*
********
recode best_gen (1=1 "Male") (2=0 "Female"), gen(male)
replace male=roster_male if male==.
label variable male "Male dummy"
gen male_d=male!=.

******
*Race*
******

rename best_race race
recode race (min/0=.)
gen race_d=race!=.
replace race=1 if race==. 
*Set race to African for all non-responders, but we control for this with a dummy.
recode race (1=1 "African") (2/5=0 "Non-African"), gen(african)
recode race (2=1 "Coloured") (3/5=0 "Non-Coloured") (1=0 "Non-Coloured") , gen(coloured)
recode race (3=1 "Asian_Indian") (1/2=0 "Non-asian_indian") (4/5=0 "Non-asian_indian"), gen(asian_indian)
recode race (4=1 "White") (1/3=0 "Non-White") (5=0 "Non-White"), gen(white)
recode race (5=1 "Other") (1/4=0 "Non-Other"), gen(other)

*****
*Age*
*****

*(Note to self: use best age once that's been created.)

replace w2_best_age=0 if w2_best_age==.
gen age_d=w2_best_age==0
gen agesq=w2_best_age^2
label variable agesq "Age squared at interview"
gen agecu=w2_best_age^3
label variable agecu "Age cubed at interview"

*Retirement-aged individuals
gen retirement=0
replace retirement=1 if w2_best_age>=65 & male==1
replace retirement=1 if w2_best_age>=60 & male==0

***********
*Schooling*
***********

*Note to self: (Use best_edu when this is available.)

recode best_edu (-9/0=0) (1=1 "Grade 1") (2=2 "Grade 2") (3=3 "Grade 3") (4=4 "Grade 4") (5=5 "Grade 5") ///
(6=6 "Grade 6") (7=7 "Grade 7") (8=8 "Grade 8") (9=9 "Grade 9") (10=10 "Grade 10") (11=11 "Grade 11") ///
(12=12 "Grade 12") (13=10) (14=11) (15=12) (25=0 "No schooling") (16/24=12) (26/max=.), gen(schooling)
gen schooling_d=schooling!=.
gen schoolingsq=schooling^2
label variable schooling "Schooling"

*Education dummies
recode best_edu (-9/0=0) (0/12=0) (12/15=0) (25=0), gen(postschool)
replace postschool=0 if best_edu<0 & best_edu>=-9 & schooling<12
gen postschool_d=postschool!=.
tab postschool, gen(best_edu)
rename best_edu2 cert_nomat
rename best_edu3 dip_nomat
rename best_edu4 cert_mat
rename best_edu5 dip_mat
rename best_edu6 bachelors
rename best_edu7 bach_dip
rename best_edu8 honours
rename best_edu9 postgrad
rename best_edu10 othered

*Number of post-school years
recode postschool (16/17=1) (18/19=1) (20=3) (21=4) (22=4) (23=6) (24=0), gen(postschoolyears)

*Proxy for work experience
gen experience=w2_best_age-6-schooling-postschoolyears

*Trade union membership
gen tradeunion=em1tru==1
label variable tradeunion "Trade union membership"

**********************************************************************************
*Biochildren variable (number of biological children under 15 still in household)*
**********************************************************************************

*Counting the number of biological children 15 or younger still living in this household
gen biochildren=0
label variable biochildren "Number of biological children 15 or younger still living with this mother"
foreach x of numlist 1/16 {
cap destring bhdob_y`x', replace
gen biobirth`x'year=bhdob_y`x'
replace biobirth`x'year=. if biobirth`x'year>2011 & biobirth`x'year!=.
replace biobirth`x'year=. if biobirth`x'year<1900
replace biochildren=biochildren+1 if biobirth`x'year>=1997 & biobirth`x'year!=. &  bhlive`x'==1
}

replace biochildren=. if biochildren==0 & male==1
replace biochildren=. if proxy==1

egen hh_biochildren=sum(biochildren), by(w2_hhid)

************************************************************
*Household variables for household level income imputations*
************************************************************

*Household mode race
egen hhrace=mode(race), by(w2_hhid) minmode
egen hhracetemp=mode(race), by(w2_hhid) maxmode
replace hhrace=hhracetemp if hhrace==.
drop hhracetemp
gen hhrace_d=hhrace!=.
replace hhrace=0 if hhrace==.

*Maximum household education
egen hhedu=max(schooling), by(w2_hhid)
egen hhpostedu=max(postschool), by(w2_hhid)
recode hhpostedu (16/17=12) (18/19=13) (20/21=15) (22=16) (23=17) (24=.)
replace hhedu=hhpostedu if hhpostedu!=0 & hhpostedu!=.
gen hhedusq=hhedu^2

*Median household age
egen hhage=median(w2_best_age_yrs) if w2_best_age>=0 & w2_best_age<110, by(w2_hhid)
sort w2_hhid hhage
replace hhage=0 if hhage==.
egen max_age = max(w2_best_age_yrs), by(w2_hhid)

replace hhage=max_age if hhage==0 & max_age!=0 & max_age!=.
cap drop max_age

gen hhage_d=hhage!=.
replace hhage=0 if hhage==.

*Dummy variable for a trade union member present in household
egen hhtu=max(tradeunion), by(w2_hhid)

*Dummy for household receiving grant income
gen spen_rec=1 if incgovpen==1
replace spen_rec=0 if spen_rec!=1 & response==1 
gen dis_rec=1 if incdis==1
replace dis_rec=0 if dis_rec!=1 & response==1 
gen chld_rec=1 if incchld==1
replace chld_rec=0 if chld_rec!=1 & response==1 
gen fost_rec=1 if incfos==1
replace fost_rec=0 if fost_rec!=1 & response==1 
gen care_rec=1 if inccare==1
replace care_rec=0 if care_rec!=1 & response==1 

gen hhgrant=0
replace hhgrant=1 if spen_rec==1 | dis_rec==1 | chld_rec==1 | fost_rec==1 | care_rec==1
egen temp=sum(hhgrant), by(w2_hhid)
gen temp2=temp>0 & temp!=.
replace hhgrant=temp2
drop temp*

*Dummy for there being any children in the household
gen hhchld_d=hhchildren>0 & hhchildren!=.

******************************
*Cleaning the asset variables*
******************************

*Value of first property

gen houseval_rec=ownhome==1
gen houseval=propvalue

*Value of other properties

gen otherhouseval_rec=ownotherhome==1
gen otherhouseval=otherpropvalue

*****************************
*Cleaning the debt variables*
*****************************

*Debt on first property

gen housedebt_rec=(ownhome==1 & ownfullypaid!=1)
gen housedebt=bondowing

*Debt on other propeties

gen otherhousedebt_rec=(ownotherhome==1 & ownotherfullypaid!=1)
gen otherhousedebt=otherbondowing

*Livestock Assets

gen cattle_rec=aglscat==1
recode aglscatsel (min/0=.), gen(cattle)

gen sheep_rec=aglsshp==1
recode aglsshpsel (min/0=.), gen(sheep)

gen goats_rec=aglsgt==1
recode aglsgtsel (min/0=.), gen(goats)

gen pigs_rec=aglspig==1
recode aglspigsel (min/0=.), gen(pigs)

gen horses_rec=aglshrs==1
recode aglshrssel (min/0=.), gen(horses)

gen donkeys_rec=aglsdnk==1
recode aglsdnksel (min/0=.), gen(donkeys)

gen chickens_rec=aglschc==1
recode aglschcsel (min/0=.), gen(chickens)

*INDIVIDUAL-LEVEL VARIABLES

*Business Assets

gen busass_rec=(ems==1 & emssll==1)
recode emslft (min/0=.), gen(busass)

gen temp1=.
replace temp1=2500 if emslft_brac4==3
replace temp1=5000 if emslft_brac4==2
replace temp1=7500 if emslft_brac4==1 & emslft_brac2==3
replace temp1=10000 if emslft_brac2==2
replace temp1=16250 if emslft_brac2==1 & emslft_brac1==3
replace temp1=25000 if emslft_brac1==2
replace temp1=37500 if emslft_brac1==1 & emslft_brac3==3
replace temp1=50000 if emslft_brac3==2
replace temp1=75000 if emslft_brac3==1 & emslft_brac5==3
replace temp1=100000 if emslft_brac5==2
replace temp1=200000 if emslft_brac5==1

replace busass=temp1 if ems==1 & emssll==1 & busass==.

drop temp1

*Business Debts

gen busdeb_rec=(ems==1 & emssll==3)
recode emsdbt (min/0=.), gen(busdeb)

gen temp1=.
replace temp1=2500 if emsdbt_brac4==3
replace temp1=5000 if emsdbt_brac4==2
replace temp1=7500 if emsdbt_brac4==1 & emsdbt_brac2==3
replace temp1=10000 if emsdbt_brac2==2
replace temp1=16250 if emsdbt_brac2==1 & emsdbt_brac1==3
replace temp1=25000 if emsdbt_brac1==2
replace temp1=37500 if emsdbt_brac1==1 & emsdbt_brac3==3
replace temp1=50000 if emsdbt_brac3==2
replace temp1=75000 if emsdbt_brac3==1 & emsdbt_brac5==3
replace temp1=100000 if emsdbt_brac5==2
replace temp1=150000 if emsdbt_brac5==1

replace busdeb=temp1 if ems==1 & emssll==3 & busdeb==.

drop temp1

*Vehicle Assets

gen priveh_rec=ownvehpri==1
recode ownvehpr_v (min/0=.), gen(priveh)

gen bakkie_rec=ownvehcom==1
recode ownvehcm_v(min/0=.), gen(bakkie)

gen scooter_rec=ownmot==1
recode ownmot_v (min/0=.), gen(scooter)

*Vehicle Debts

gen vehdebt_rec=dtveh==1
recode dtveh_b (min/0=.), gen(vehdebt)

*Financial Assets

gen cash_rec=ascash==1
recode ascash_v (min/0=.), gen(cash)

gen bank_rec=asacc==1
recode asacc_v (min/0=.), gen(bank)

gen life_rec=aslifeins==1
recode aslifeins_v (min/0=.), gen(life)

gen stocks_rec=asfin==1
recode asfin_v (min/0=.), gen(stocks)

*Financial Debts

gen bankdebt_rec=dtbnk==1
recode dtbnk_b (min/0=.), gen(bankdebt)

gen micro_rec=dtmic==1
recode dtmic_b (min/0=.), gen(micro)

gen masho_rec=dtmsh==1
recode dtmsh_b (min/0=.), gen(masho)

gen studentloan_rec=dtstubnk==1
recode dtstubnk_b (min/0=.), gen(studentloan)

gen otherstudentloan_rec=dtstuo==1
recode dtstuo_b (min/0=.), gen(otherstudentloan)

gen creditcard_rec=dtcre==1
recode dtcre_b (min/0=.), gen(creditcard)

gen store_rec=dtstr==1
recode dtstr_b (min/0=.), gen(store)

gen hirep_rec=dthp==1
recode dthp_b (min/0=.), gen(hirep)

gen famloan_rec=dtflloan==1
recode dtflloan_b (min/0=.), gen(famloan)

gen friendloan_rec=dtfrloan==1
recode dtfrloan_b (min/0=.), gen(friendloan)

gen emploan_rec=dtemploan==1
recode dtemploan_b (min/0=.), gen(emploan)

gen unpaidtax_rec=dtunpdtax==1
recode dtunpdtax_b (min/0=.), gen(unpaidtax)

*Retirement Funding

gen pension_rec=aspen==1
recode aspen_v (min/0=.), gen(pension)

*Value of livestock

foreach var of varlist houseval otherhouseval housedebt  otherhousedebt ///
cattle sheep goats pigs horses donkeys chickens {
replace `var'=. if hhresponse!=1
replace `var'_rec=. if hhresponse!=1
gen `var'_d=`var'!=.
replace `var'_d=. if hhresponse!=1
}

foreach var of varlist busass busdeb priveh bakkie scooter vehdebt cash ///
bank life stocks bankdebt micro masho studentloan otherstudentloan ///
creditcard store hirep famloan friendloan emploan unpaidtax pension {
replace `var'=. if response!=1
replace `var'_rec=. if response!=1
gen `var'_d=`var'!=.
replace `var'_d=. if response!=1
}

save "$DataOUT\prepdata.dta", replace

* end of do file
*===================================================================================================================================
